﻿#include  "StdAfx.h"

#include  <szStoredItemContainer.hpp>
#include  <szStoredItem.hpp>
#include  <szPath.hpp>

#include  <boost/lambda/algorithm.hpp>
#include  <boost/lambda/bind.hpp>
#include  <boost/lambda/construct.hpp>
#include  <boost/lambda/lambda.hpp>

using namespace boost::lambda;

SZ_NS_BEG(szpp)

StoredItemContainer::StoredItemContainer(const szstring &name) : thisItem(0), subItems(), subContainers(), parent(0), name(name)
{
}

StoredItemContainer::~StoredItemContainer()
{
  // 格納アイテムの所有権は持たないので削除しない。
  // for_each(subItems.begin(), subItems.end(), bind(delete_ptr(), _1));
  // サブコンテナは所有権を持っているので削除。
  for_each(subContainers.begin(), subContainers.end(), bind(delete_ptr(), _1));
}

void  StoredItemContainer::SetItem(StoredItem *item)
{
  thisItem = item;
}

StoredItem *StoredItemContainer::FindSubItem(const szstring &targetName)
{
  for (std::vector<StoredItem *>::iterator i = subItems.begin(); i != subItems.end(); ++i)
  {
    if ((*i)->GetName().compare(targetName) == 0)
      return *i;
  }
  return 0;
}

const StoredItem *StoredItemContainer::FindSubItem(const szstring &targetName) const
{
  for (std::vector<StoredItem *>::const_iterator i = subItems.begin(); i != subItems.end(); ++i)
  {
    if ((*i)->GetName().compare(targetName) == 0)
      return *i;
  }
  return 0;
}

void StoredItemContainer::AddSubItem(StoredItem *item)
{
  subItems.push_back(item);
}

StoredItemContainer *StoredItemContainer::FindSubContainer(const szstring &targetName)
{
  for (std::vector<StoredItemContainer *>::iterator i = subContainers.begin(); i != subContainers.end(); ++i)
  {
    if ((*i)->name.compare(targetName) == 0)
      return *i;
  }
  return 0;
}

const StoredItemContainer *StoredItemContainer::FindSubContainer(const szstring &targetName) const
{
  for (std::vector<StoredItemContainer *>::const_iterator i = subContainers.begin(); i != subContainers.end(); ++i)
  {
    if ((*i)->name.compare(targetName) == 0)
      return *i;
  }
  return 0;
}

StoredItemContainer *StoredItemContainer::FindDescendant(const szstring &targetName)
{
  StoredItemContainer *currentContainer = this;
  std::deque<szstring> elements = Decompose(targetName);
  while (!elements.empty() && currentContainer != 0)
  {
    const szstring &elem = elements.front();
    currentContainer = currentContainer->FindSubContainer(elem);
    elements.pop_front();
  }
  return currentContainer;
}

const StoredItemContainer *StoredItemContainer::FindDescendant(const szstring &targetName) const
{
  const StoredItemContainer *currentContainer = this;
  std::deque<szstring> elements = Decompose(targetName);
  while (!elements.empty() && currentContainer != 0)
  {
    const szstring &elem = elements.front();
    currentContainer = currentContainer->FindSubContainer(elem);
    elements.pop_front();
  }
  return currentContainer;
}

void StoredItemContainer::AddSubContainer(StoredItemContainer *subcontainer)
{
  subContainers.push_back(subcontainer);
}

SZ_NS_END(szpp)
